function spells_has_crossbow_equipped( out name__ : string ) : bool
{
	var xbow		: SItemUniqueId;
	var has			: bool;

	has = false;
	name__ = "";

	if ( thePlayer.GetInventory().GetItemEquippedOnSlot( EES_RangedWeapon,  xbow  ) )
	{
		has = true;
	}
	
	if ( has )
	{
		name__ = GetLocStringByKeyExt( thePlayer.GetInventory().GetItemLocalizedNameByUniqueID( xbow ) );
		return true;
	}
	else
	{
		return false;
	}
	
}

function is_holding_sword_spells() : bool
{
	var steelid, silverid		: SItemUniqueId;

	thePlayer.GetInventory().GetItemEquippedOnSlot( EES_SteelSword,  steelid  );
	thePlayer.GetInventory().GetItemEquippedOnSlot( EES_SilverSword, silverid );
	
	if ( thePlayer.GetInventory().IsItemHeld( steelid ) || thePlayer.GetInventory().IsItemHeld( silverid ) )
	{
		return true;
	}
	
	return false;
}


function spells_can_dismember( actor : CActor ) : bool
{
	if ( RandF() <= get_spells_dismember_chance() )
	{
		if ( !actor.HasTag( 'DisableDismemberment' ) && actor.IsOnGround()  )
		{
			if ( actor.IsHuman() || actor.IsAnimal() )
			{
				if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_dismember_human') )
				{
					return true;
				}
			}
			else
			{
				if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_dismember_monster') )
				{
					return true;
				}
			}
		}
	}
	
	return false;
}	


function find_position_spells( pos : Vector ) : Vector
{
	var tempPosition1, tempPosition2, outPosition,outNormal  : Vector;

	tempPosition1 = pos;
	tempPosition1.Z -= 10;
	
	tempPosition2 = pos;
	tempPosition2.Z += 10;

	if ( theGame.GetWorld().StaticTrace( tempPosition2, tempPosition1, outPosition, outNormal ) )
	{
		pos = outPosition;
	}
	return pos;
}


function register_cancel_input_spells()
{
	if ( !GetMagicDreamer().active )
	{
		theInput.RegisterListener( GetMagicVigil(),				'OnCbtDodgeSpells', 					'Dodge' );
		theInput.RegisterListener( GetMagicVigil(),				'OnCbtRollSpells',  					'CbtRoll' );
		theInput.RegisterListener( GetMagicVigil(),				'OnLockAndGuardSpells', 				'LockAndGuard' );
																										
		theInput.RegisterListener( GetMagicVigil(),				'OnCbtAttackLightSpells',  				'AttackLight' );
		theInput.RegisterListener( GetMagicVigil(),				'OnCbtAttackHeavySpells', 				'AttackHeavy' );
																										
		theInput.RegisterListener( GetMagicVigil(),				'OnCbtAttackLightSpells2',  			'AttackWithAlternateLight' );
		theInput.RegisterListener( GetMagicVigil(),				'OnCbtAttackHeavySpells2', 				'AttackWithAlternateHeavy' );
	}
}

function unregister_cancel_input_spells()
{
	if ( !GetMagicDreamer().active )
	{
		theInput.RegisterListener( thePlayer.GetInputHandler(), 'OnCbtDodge', 							'Dodge' );
		theInput.RegisterListener( thePlayer.GetInputHandler(), 'OnCbtRoll', 							'CbtRoll' );
		theInput.RegisterListener( thePlayer.GetInputHandler(), 'OnCbtLockAndGuard', 					'LockAndGuard' );
					
		theInput.RegisterListener( thePlayer.GetInputHandler(), 'OnCbtAttackLight', 					'AttackLight' );
		theInput.RegisterListener( thePlayer.GetInputHandler(), 'OnCbtAttackHeavy', 					'AttackHeavy' );
		
		theInput.RegisterListener( thePlayer.GetInputHandler(), 'OnCbtAttackWithAlternateLight', 		'AttackWithAlternateLight' );
		theInput.RegisterListener( thePlayer.GetInputHandler(), 'OnCbtAttackWithAlternateHeavy', 		'AttackWithAlternateHeavy' );
	}
}

function clear_guarding_buffs( keep_quen : bool )
{
	if ( !keep_quen )
	{	
		GetWitcherPlayer().FinishQuen( true, true );
	}
	thePlayer.RemoveBuff( EET_BlackfireShield );
	thePlayer.RemoveBuff( EET_Wintershield );
	thePlayer.RemoveBuff( EET_Energyshield );
	thePlayer.RemoveBuff( EET_QuilegShield );
}

function guarding_buffs() : bool
{
	return 	thePlayer.HasBuff( EET_BlackfireShield ) 
			|| thePlayer.HasBuff( EET_Wintershield )
			|| thePlayer.HasBuff( EET_Energyshield )      
			|| thePlayer.HasBuff( EET_QuilegShield )                                          
			;
}

function GetMagicEffectRight() : CEntity
{
	var right_effect 			 : CEntity;
	
	right_effect = (CEntity)theGame.GetEntityByTag( 'magic_spell_right_hand_fx' );
	return right_effect;
}

function GetMagicEffectLeft() : CEntity
{
	var left_effect 			 : CEntity;
	
	left_effect = (CEntity)theGame.GetEntityByTag( 'magic_spell_left_hand_fx' );
	return left_effect;
}

function Spells_drain_stamina( stamina_cost : float, stamina_delay : float, signskill : ESkill )
{
	stamina_cost = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( signskill, 'stamina_cost', false, true ) );
	stamina_cost += stamina_cost * get_stamina_cost_mult(); 
	
	stamina_delay = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( signskill, 'stamina_delay', false, true ) );
	stamina_delay += stamina_delay * get_stamina_delay_mult(); 
		
	GetWitcherPlayer().DrainStamina( ESAT_FixedValue, stamina_cost, stamina_delay ); 
}

function Spells_drain_stamina_cut( div : float, stamina_cost : float, stamina_delay : float, signskill : ESkill )
{
	stamina_cost = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( signskill, 'stamina_cost', false, true ) );
	stamina_cost += stamina_cost * get_stamina_cost_mult(); 
	stamina_cost *= div; 
	
	stamina_delay = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( signskill, 'stamina_delay', false, true ) );
	stamina_delay += stamina_delay * get_stamina_delay_mult(); 
	stamina_delay *= div; 
		
	GetWitcherPlayer().DrainStamina( ESAT_FixedValue, stamina_cost, stamina_delay ); 
}

function Spells_overall_stamina_cost() : float
{
	var stamina_cost  : float;
	
	stamina_cost = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( S_Magic_1, 'stamina_cost', false, true ) );
	stamina_cost += CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( S_Magic_2, 'stamina_cost', false, true ) );
	stamina_cost += CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( S_Magic_3, 'stamina_cost', false, true ) );
	stamina_cost += CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( S_Magic_4, 'stamina_cost', false, true ) );
	stamina_cost += CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( S_Magic_5, 'stamina_cost', false, true ) );
	
	stamina_cost = stamina_cost / 5;
	
	return stamina_cost;
}

function can_interrupt_custom() : bool
{
	var can : bool;
	
	can = false;

	if ( GetMagicVigil().is_in_custom_anim )
	{
		if ( GetMagicVigil().state_name == 'SwordRingSpells' )
		{
			if ( GetMagicVigil().can_interrupt )
			{
				can = true;
			}
			else if ( GetMagicVigil().spell_name != 'sword_aard_cone' )
			{
				can = true;
			}
		}
	}

	
	return can;
}

function spell_cast_allowed() : bool
{
	var entities_int						: array<CGameplayEntity>;
	var i 									: int;
	var cond_0, cond_1, cond_2 				: bool;
	var weapons 							: array< SItemUniqueId >;
	
	cond_0 = true;
	cond_1 = true;
	cond_2 = true;
	
	weapons = thePlayer.GetInventory().GetHeldWeapons();
	for( i=0; i<weapons.Size(); i+=1 )
	{	
		if ( thePlayer.GetInventory().IsItemCrossbow( weapons[i] ) 
			|| 	thePlayer.GetInventory().IsItemBolt( weapons[i] ) 
			|| 	thePlayer.GetInventory().IsItemBomb( weapons[i] ) )
		{	return false;	 }
	}
	
	if (  !GetMagicVigil().is_in_manual_aiming
		  //&& thePlayer.GetStatPercents( BCS_Stamina ) > 0.8
		  && !GetWitcherPlayer().IsCastingSign()
		  && thePlayer.GetBIsInputAllowed()
		  //&& thePlayer.GetBIsCombatActionAllowed()
		  && thePlayer.IsActionAllowed(EIAB_Signs)
		  && thePlayer.GetCurrentStateName() != 'Meditation' && thePlayer.GetCurrentStateName() != 'MeditationWaiting'
		  //&& thePlayer.GetCombatAction() == EBAT_EMPTY
		  //&&  thePlayer.GetCombatAction() != EBAT_LightAttack
		  && thePlayer.IsActionAllowed(EIAB_Dodge)
		  && ( thePlayer.GetCurrentStateName() == 'CombatFists' || thePlayer.GetCurrentStateName() == 'CombatSilver' 
				|| thePlayer.GetCurrentStateName() == 'Exploration' || thePlayer.GetCurrentStateName() == 'CombatSteel' )
		  && thePlayer.rangedWeapon.GetCurrentStateName() != 'State_WeaponHolster'
		

			/*
			&& thePlayer.GetCurrentStateName() != 'AimThrow'
			&& thePlayer.GetCurrentStateName() != 'Unconscious'
			&& thePlayer.GetCurrentStateName() != 'Sailing'
			&& thePlayer.GetCurrentStateName() != 'Sailing'
			*/
	   )
	{
		cond_0 = true;
	}
	else
	{
		cond_0 = false;
	}
		
		
	
	if ( theGame.GetInteractionsManager().GetActiveInteraction() )
	{
		cond_2 = false;
	}
	
	if ( !thePlayer.IsInCombat() )  
	{
		FindGameplayEntitiesInRange(entities_int, thePlayer, 3, 100 );
		
		if ( entities_int.Size()>0 )
		{
			for( i=0; i<entities_int.Size(); i+=1 )
			{
				if ( ( CMajorPlaceOfPowerEntity )entities_int[i] )
				{
					cond_1 = false;
				}
			} 	
		}
	}
	
	return ( cond_0 && cond_1 && cond_2 );

}

function check_bolts_spells( optional holding : bool ) : Bool
{
	var idit, idx 		: SItemUniqueId;
	var value, value2	: bool;
	
	value = false;
	
	GetWitcherPlayer().GetItemEquippedOnSlot(EES_Bolt, idit);
	GetWitcherPlayer().GetItemEquippedOnSlot(EES_RangedWeapon, idx);
	
	if ( thePlayer.GetInventory().IsItemCrossbow( thePlayer.GetInventory().GetItemFromSlot('l_weapon') ) )
	{
		value = true;
	}
	else
	{
		value = false;
	}
	
	if (	thePlayer.GetInventory().GetItemName( idit ) != 'Split Bolt'
			&& thePlayer.GetInventory().GetItemName( idit ) != 'Split Bolt Legendary'
	)
	{
		value = true;
	}
	else
	{
		value = false;
	}
	
	if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'use_only_simple_bolts_for_xbow_spells') )
	{
		if ( 	thePlayer.GetInventory().GetItemName( idit ) == 'Bodkin Bolt' 
			||	thePlayer.GetInventory().GetItemName( idit ) == 'Harpoon Bolt'
		)
		{
			value = true;
		}
		else
		{
			value = false;
		}
	}
	
	if ( holding )
	{
		if ( thePlayer.GetInventory().IsItemHeld( idx ) )
		{
			value2 = true;
		}
		else
		{
			value2 = false;
		}
		
		value = value && value2;
	}
	
	return value;
}

function get_spellpower_spells( total : bool, optional signskill : ESkill ) : Float
{
	var sp 												: SAbilityAttributeValue;
	var valueAbility 									: float;
	
	if ( total )
	{
		sp = GetWitcherPlayer().GetTotalSignSpellPower (S_Magic_1);
		sp += GetWitcherPlayer().GetTotalSignSpellPower(S_Magic_2);
		sp += GetWitcherPlayer().GetTotalSignSpellPower(S_Magic_3);
		sp += GetWitcherPlayer().GetTotalSignSpellPower(S_Magic_4);
		sp += GetWitcherPlayer().GetTotalSignSpellPower(S_Magic_5);
		
		valueAbility = sp.valueMultiplicative / 5 - 1;
	}
	else
	{
		sp = GetWitcherPlayer().GetTotalSignSpellPower(signskill);
		
		valueAbility = sp.valueMultiplicative - 1;
	}
	
	//theGame.witcherLog.AddMessage("valueAbility = " + valueAbility );
	
	//theGame.witcherLog.AddMessage("sign skill = " + (string)( GetMagicVigil().get_signskill_spells() ) );
	
	return valueAbility;
}

function get_spellpower_spells_signs() : Float
{
	var sp 												: SAbilityAttributeValue;
	var valueAbility 									: float;
	
	switch( GetWitcherPlayer().GetEquippedSign() )
	{
		case ST_Aard:
			{
				sp = GetWitcherPlayer().GetTotalSignSpellPower (S_Magic_1);
			}
			break;
		case ST_Axii:
			{
				sp = GetWitcherPlayer().GetTotalSignSpellPower (S_Magic_5);
			}
			break;
		case ST_Igni:
			{
				sp = GetWitcherPlayer().GetTotalSignSpellPower (S_Magic_2);
			}
			break;
		case ST_Yrden:
			{
				sp = GetWitcherPlayer().GetTotalSignSpellPower (S_Magic_3);
			}
			break;
		case ST_Quen:
			{
				sp = GetWitcherPlayer().GetTotalSignSpellPower (S_Magic_4);
			}
			break;
		default:		
			break;
	}
	valueAbility = sp.valueMultiplicative - 1;
	
	return valueAbility;
}

function GetMagicShoot() : CEntity
{
	var hand 			 : CEntity;
	
	hand = theGame.GetEntityByTag( 'magic_spell_shoot_effect' );
	return hand;
}

function GetMagicAim() : CEntity
{
	var hand 			 : CEntity;
	
	hand = theGame.GetEntityByTag( 'magic_spell_aim_effect' );
	return hand;
}

function GetMagicVigil() : W3MagicVigil
{
	var vigil 			 : W3MagicVigil;
	
	vigil = (W3MagicVigil)theGame.GetEntityByTag( 'W3MagicVigil' );
	return vigil;
}

function GetMagicDreamer() : W3MagicDreamer
{
	var dreamer 			 : W3MagicDreamer;
	
	dreamer = (W3MagicDreamer)theGame.GetEntityByTag( 'W3MagicDreamer' );
	return dreamer;
}

function get_magic_item_quickslot() : name
{
	var i 					: int;
	var item_name 			: name;
	var item_names 			: array<name>;
	
	item_names = GetMagicVigil().get_quickslot_item_names();

	item_name = 'empty';

	for( i=0; i<item_names.Size(); i+=1 )
	{
		if( GetWitcherPlayer().IsItemEquippedByName( item_names[i] ) && GetWitcherPlayer().GetInventory().GetItemId( item_names[i] ) == GetWitcherPlayer().GetSelectedItemId() )
		{		
			item_name = item_names[i];		
		}
	}

	return item_name;
}

function get_magic_item_trophy() : name
{
	var i 					: int;
	var item_name 			: name;
	var item_names 			: array<name>;
	
	item_names = GetMagicVigil().get_trophy_item_names();

	item_name = 'empty';

	for( i=0; i<item_names.Size(); i+=1 )
	{
		if( GetWitcherPlayer().GetHorseManager().IsItemEquippedByName( item_names[i] ) )
		{		
			item_name = item_names[i];		
		}
	}

	return item_name;
}

function spells_get_pelvis_name(	actor: CActor	) : name
{
	var boneName : name;
	var boneIndex : int;
	
	boneName = 'pelvis';
	boneIndex = actor.GetBoneIndex( boneName );		
	if( boneIndex == -1 )
	{
		boneName = 'k_pelvis_g';
	}
	
	return boneName;
}

function spells_has_enough_stamina( signskill : ESkill ) : bool
{
	var stamina_cost : float;

	stamina_cost = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( signskill, 'stamina_cost', false, true ) );
	stamina_cost += stamina_cost * get_stamina_cost_mult(); 
	
	if ( thePlayer.GetStat(BCS_Stamina) >= stamina_cost )
	{
		return true;
	}
	else
	{
		thePlayer.SetShowToLowStaminaIndication( stamina_cost );
		return false;
	}
}

function spells_has_enough_stamina_sword( signskill : ESkill ) : bool
{
	var stamina_cost : float;

	stamina_cost = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( signskill, 'stamina_cost', false, true ) );
	stamina_cost += stamina_cost * get_stamina_cost_mult(); 
	stamina_cost *= 0.5;
	
	if ( thePlayer.GetStat(BCS_Stamina) >= stamina_cost )
	{
		return true;
	}
	else
	{
		thePlayer.SetShowToLowStaminaIndication( stamina_cost );
		return false;
	}
}

function can_init_swordless_spells() : Bool
{
	/*
	if ( 	thePlayer.GetCurrentStateName() == 'CombatFists' 
			//&& thePlayer.IsInCombat()
			&& !GetWitcherPlayer().IsInFistFight() 
			&& !thePlayer.IsInFistFightMiniGame() 
			&& ( thePlayer.GetInventory().HasItem('spelltome_doll') || GetWitcherPlayer().GetHorseManager().IsItemEquippedByName('spelltome_doll') )
		)
		*/
		
		
	if ( 	
			//!is_holding_sword_spells()
			thePlayer.GetCurrentStateName() == 'CombatFists' 
			&& thePlayer.IsInCombat()
			&& !GetWitcherPlayer().IsInFistFight() 
			&& !thePlayer.IsInFistFightMiniGame() 
			&& ( thePlayer.GetInventory().HasItem('spelltome_doll') || GetWitcherPlayer().GetHorseManager().IsItemEquippedByName('spelltome_doll') )
		)
	{ 
		return true; 
	}
	else
	{ 
		return false;
	}
}


function register_swordless_input_spells()
{
	theInput.RegisterListener( GetMagicDreamer(),			'OnSwordless_Dodge', 					'Dodge' );
	theInput.RegisterListener( GetMagicDreamer(),			'OnSwordless_Roll',  					'CbtRoll' );
	theInput.RegisterListener( GetMagicDreamer(),			'OnSwordless_Guard', 					'LockAndGuard' );
																									
	theInput.RegisterListener( GetMagicDreamer(),			'OnSwordless_AttackLight',  			'AttackLight' );
	theInput.RegisterListener( GetMagicDreamer(),			'OnSwordless_AttackHeavy', 				'AttackHeavy' );
																									
	theInput.RegisterListener( GetMagicDreamer(),			'OnSwordless_AttackLight2',  			'AttackWithAlternateLight' );
	theInput.RegisterListener( GetMagicDreamer(),			'OnSwordless_AttackHeavy2', 			'AttackWithAlternateHeavy' );
}

function unregister_swordless_input_spells()
{
	theInput.RegisterListener( thePlayer.GetInputHandler(), 'OnCbtDodge', 							'Dodge' );
	theInput.RegisterListener( thePlayer.GetInputHandler(), 'OnCbtRoll', 							'CbtRoll' );
	theInput.RegisterListener( thePlayer.GetInputHandler(), 'OnCbtLockAndGuard', 					'LockAndGuard' );
				
	theInput.RegisterListener( thePlayer.GetInputHandler(), 'OnCbtAttackLight', 					'AttackLight' );
	theInput.RegisterListener( thePlayer.GetInputHandler(), 'OnCbtAttackHeavy', 					'AttackHeavy' );
	
	theInput.RegisterListener( thePlayer.GetInputHandler(), 'OnCbtAttackWithAlternateLight', 		'AttackWithAlternateLight' );
	theInput.RegisterListener( thePlayer.GetInputHandler(), 'OnCbtAttackWithAlternateHeavy', 		'AttackWithAlternateHeavy' );
}

function spell_manual_aiming_allowed() : bool
{
	if (
		  thePlayer.GetStatPercents( BCS_Stamina ) > 0.19
		  && !GetWitcherPlayer().IsCastingSign()
		  && thePlayer.GetBIsInputAllowed()
		  && thePlayer.IsActionAllowed(EIAB_Signs)
		  && !thePlayer.IsHoldingItemInLHand()
		  && !thePlayer.GetInventory().IsItemCrossbow(thePlayer.GetSelectedItemId()) 
		  && !thePlayer.GetInventory().IsItemBomb(thePlayer.GetSelectedItemId()) 
		  && !thePlayer.GetInventory().IsItemUsable(thePlayer.GetSelectedItemId())	   
		  && thePlayer.GetCurrentStateName() != 'Meditation' && thePlayer.GetCurrentStateName() != 'MeditationWaiting'
		)
	{
		return true;
	}
	else
	{
		return false;
	}
}
